//
//  HeroShareModel.h
//  HeroGlobal
//
//  Created by 曾传文 on 2019/11/13.
//  Copyright © 2019 谢宗文. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "HeroPublicTag.h"

NS_ASSUME_NONNULL_BEGIN

@interface HeroShareModel : NSObject

@property (nonatomic, assign ) HeroShareType      shareType; //分享类型 （必填）
@property (nonatomic, assign ) HeroSharePlatform  sharePlatform ; //分享平台（必填）
//分享图片需要填写的参数
@property (nonatomic, strong ) UIImage         *shareImage;//分享图片（分享图片与链接2选一）
@property (nonatomic, copy  ) NSString         *imageLink;//分享图片链接（分享图片与链接2选一）
//分享链接需要填写的参数
@property (nonatomic, copy  ) NSString          *shareLink;//分享链接 （分享链接必填）
@property (nonatomic, copy  ) NSString          *shareLinkTitle;//分享链接标题（分享链接必填）
@property (nonatomic, copy  ) NSString          *shareLinkDescription;//分享链接描述（分享链接必填）
//分享文本需要填写的参数
@property (nonatomic, copy  ) NSString          *shareText;//分享纯文本文字 （分享纯文本必填）
@property (nonatomic,copy  ) NSString           *shareTextContent;//分享纯文本描述 （分享纯文本选填）
@end

NS_ASSUME_NONNULL_END
