//
//  UOPInstantPlayDefines.h
//  UnionOpenPlatformTeamPlay
//
//  Created by Chaoli on 2023/7/27.
//

#ifndef UOPInstantPlayDefines_h
#define UOPInstantPlayDefines_h

typedef NS_ENUM(NSUInteger, UOPTeamPlayAccessTokenUpdateResult) {
    UOPTeamPlayAccessTokenUpdateResultSuccess,
    UOPTeamPlayAccessTokenUpdateResultFailed,
};

typedef NS_ENUM(NSUInteger, UOPTeamPlayReportStatus) {
    UOPTeamPlayReportStatusCreateRoom = 1, // 创建房间 参数: team_size:int, room_extra:string
    UOPTeamPlayReportStatusUpdateRoom = 2, // 更新房间信息 参数: team_size, room_extra:string
    UOPTeamPlayReportStatusJoinRoom = 3, // 加入房间 参数: game_nickname:string
    UOPTeamPlayReportStatusQuitRoom = 4, // 主动退出房间
    UOPTeamPlayReportStatusKickOutRoom = 5, // 被动退出房间
    UOPTeamPlayReportStatusGameStart = 6, // 对局开始
    UOPTeamPlayReportStatusGameOver = 7, // 对局结束
};

typedef NS_ENUM(NSInteger, UOPTeamPlayErrorCode) {
    UOPTeamPlayErrorCodeServiceUnknown = -1, // 未知错误
    UOPTeamPlayErrorCodeServiceUnavailable = 10001, // 服务不可用
    UOPTeamPlayErrorCodeParamsError = 10011, // 参数错误
    UOPTeamPlayErrorCodeAccessTokenError = 20003, // token 失效错误
    UOPTeamPlayErrorCodePlayIdHasBindGameRoom = 4014342, // playid已绑定游戏房间
    UOPTeamPlayErrorCodeUserDoesNotJoinTeam = 4014341, // 用户未加入抖音车队
    UOPTeamPlayErrorCodeGameStarted = 4014344, // 游戏对局已开始
    UOPTeamPlayErrorCodeNoTeamPlayRecord = 4014340, // 当前用户未开启车队
};

typedef NSString *UOPTeamPlayMemberType;

FOUNDATION_EXTERN UOPTeamPlayMemberType const UOPTeamPlayMemgerTypeCreate;
FOUNDATION_EXTERN UOPTeamPlayMemberType const UOPTeamPlayMemgerTypeUser;

#endif /* UOPInstantPlayDefines_h */
