//
//  UOPTeamPlayManager.h
//  UnionOpenPlatformTeamPlay
//
//  Created by ByteDance on 2023/7/26.
//

#import <UnionOpenPlatformTeamPlay/UOPInstantPlayConfig.h>
#import <UnionOpenPlatformTeamPlay/UOPInstantPlayDefines.h>

NS_ASSUME_NONNULL_BEGIN

@protocol UOPInstantPlayManagerProcessDelegate <NSObject>

@optional

/// 回调请求创建房间
- (void)onRequestCreateRoom;

/// 回调请求加入到房间
/// - Parameters:
///   - type: 用户类型 see [UOPTeamPlayMemberType];
///   - roomExtra: 游戏透传房间信息
- (void)onRequestJoinRoomWithType:(NSString *)type roomExtra:(nullable NSString *)roomExtra;

/// 一起玩过程错误都会产生此回调
/// - Parameter error: 错误对象
- (void)onTeamPlayError:(NSError *)error;

@end

@interface UOPInstantPlayManager : NSObject

/// 一起玩流程代理
@property (nonatomic, weak) id<UOPInstantPlayManagerProcessDelegate> delegate;

+ (instancetype)sharedManager;

/// 初始化游戏配置
/// @param config 游戏配置
- (void)setupWithConfig:(UOPInstantPlayConfig *)config;

/// 打开第三方平台,在9.0后 必须在application:openURL:url options:中调用该接口
/// @attention 必须在主线程中调用
/// @param   url         第三方应用打开APP时传递过来的URL
/// @param   options     第三方应用打开APP时传递过来的options
/// @return  成功返回YES，失败返回NO。
- (BOOL)handleOpenURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey,id> *)options;



/// 上报房间信息
/// @param status 参考枚举 [UOPTeamPlayReportStatus]
/// @param data 参数
/// @param complete 回调
- (void)reportGameRoomStatus:(NSInteger)status data:(NSDictionary<NSString *, id> *)data complete:(void (^)(NSError * _Nullable error))complete;

/// 获取当前游戏房间的roomExtra
- (void)getBindGameRoomExtraWithComplete:(void (^)(NSString * _Nullable roomExtra, NSError * _Nullable error))completion;

@end

NS_ASSUME_NONNULL_END
