//
//  HGameSwiftBridgeManager.h
//  Game
//
//  Created by 魏太山 on 2021/12/15.
//  Copyright © 2021 Hero. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
typedef void(^HMCompleteBlock)(NSDictionary<NSString *, id> *resultData, NSError *error);

@interface HGameSwiftBridgeManager : NSObject

/** 支付挽留-私域地址*/
@property (nonatomic, copy) NSString *linkString ;

+ (instancetype)sharedInstance;

- (void)networkWithUrl:(NSString *)url params:(NSMutableDictionary *)params completion:(HMCompleteBlock)completion;

- (void)showWechatAttentionViewWithTrack:(NSDictionary *)currentTrackDic;

/**
 *  获取微信关注弹窗链接
 *  @param completion   回调
 */
- (void)getWechatAttentionLinkWithCompletion:(HMCompleteBlock)completion ;

/**
 * 获取支付挽留，支付完成礼包领取是否显示
 */
- (void)payRetentionPackageResult:(NSString *)sourceType completion:(HMCompleteBlock)completion ;


- (BOOL)isLogin;
@end

NS_ASSUME_NONNULL_END
