//
//  UOPReplayManager.h
//  UnionOpenPlatform
//
//  Created by ByteDance on 2023/4/3.
//

#import <Foundation/Foundation.h>
#import <UnionOpenPlatformReplay/UOPReplayConfig.h>
#import <UnionOpenPlatformReplay/UOPReplayDefine.h>
#import <UnionOpenPlatformReplay/UOPReplayVideoModel.h>

NS_ASSUME_NONNULL_BEGIN

/// 策略类型
typedef NS_ENUM(int, UOPReplayType) {
    /// 关闭
    UOPReplayTypeClose,
    /// 厂商控制录制
    UOPReplayTypeAuto,
    /// 用户自由录制
    UOPReplayTypeManual
} API_DEPRECATED("参考 setType:completion: 方法上的说明，相关调用可以移除，内部默认赋值为 UOPReplayTypeAuto", ios(8.0, 10.0)) ;

/// 画面数据代理
@protocol UOPReplayManagerMetalDataSource <NSObject>

@optional

/// 获取 Metal MTLCommandQueue
/// @abstract 仅画面接口为Metal的需要实现，OpenGL不要实现本方法；
- (id<MTLCommandQueue>)UOPReplayGetMetalMTLCommandQueue;

@end

/// 录制事件代理
@protocol UOPReplayManagerDelegate <NSObject>

@optional

/// 录制开始事件
/// @param roundID 本次录制标识
/// @param code 事件Code，详见 UOPReplayDefine
- (void)replayDidStartRecord:(nullable NSString *)roundID
                    withCode:(UOPReplayErrorCode)code;

/// 录制结束事件
/// @discussion 录制中断，录制结束失败均会触发
/// @param roundID 本次录制标识
/// @param code 事件Code，详见 UOPReplayDefine
/// @param videoPath 视频地址
- (void)replayDidStopRecord:(nullable NSString *)roundID
                   withCode:(UOPReplayErrorCode)code
                  videoPath:(nullable NSString *)videoPath;

@end

/// 录制管理类
@interface UOPReplayManager : NSObject

+ (instancetype)sharedManager;

@property (nonatomic, weak) id<UOPReplayManagerMetalDataSource> metalDataSource;

@property (nonatomic, weak) id<UOPReplayManagerDelegate> delegate;

/// 设置录制参数
/// @param config 录制参数
/// @param completion 设置完成回调
- (void)setConfig:(UOPReplayConfig *)config
       completion:(nullable void(^)(UOPReplayErrorCode code))completion;
/// 当前录制参数
@property (readonly) UOPReplayConfig *config;

/// 功能是否可用
- (BOOL)isSupport;

/// 是否正在录制中
- (BOOL)isRecording;

/// 当前录制时长，单位ms
/// @discussion 生命周期内的首次启动可能会因为设备性能差异持续一小段时间返回0；
/// @discussion 画面采集异常会持续返回0；
- (long)currentRecordingDuration;

/// 开始录制
- (void)startAutoRecord;

/// 结束录制
- (void)stopAutoRecord;

/// 获取当前已录制视频对象列表
- (NSArray <UOPReplayVideoModel *>*)fetchReplayFileList;

/// 删除指定视频及封面文件
- (void)removeReplayFileAtPath:(NSString *)filePath;

/// 删除所有已录制视频和封面文件
- (void)removeAllReplayFile;

#pragma mark - DEPRECATED

/// 当前录制策略
@property (readonly) UOPReplayType type API_DEPRECATED("调用可以移除，内部默认赋值为 UOPReplayTypeAuto", ios(8.0, 10.0));

/// 设置录制策略
/// @discussion 现在会默认设置为 UOPReplayTypeAuto 厂商控制模式，可以不再主动调用本接口；
/// @discussion 接口声明会持续保留，功能也会持续保留；
/// @param type 策略类型
/// @param completion 设置完成回调
- (void)setType:(UOPReplayType)type
     completion:(nullable void(^)(UOPReplayErrorCode code))completion API_DEPRECATED("调用可以移除，内部默认赋值为 UOPReplayTypeAuto", ios(8.0, 10.0));

@end


NS_ASSUME_NONNULL_END
